/* ============ */
/* setscctl.c	*/
/* ============ */
#include <srcrdefs.h>
#include <miscdefs.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>

#define	ACT(X)	#X

#define	CLAMP(Out, Var, Lo, Hi)	Out = __min(Hi, __max(Lo, Var))

#define	NEED_ALL(Label)	"Enter "Label

#define	NEED_USER_ENTRY(LABEL, LO, HI) \
	NEED_ALL(LABEL" ["ACT(LO)"-"ACT(HI)"]: ")

#define	COEFS_PER_CHI_SQ	\
	"Number of Serial Correlations Per Chi-Square"
#define	VARIATES_PER_CHI_SQ	\
	"Corresponding Number of Variates to be Generated"

#define	REPORT_USER_INT_ENTRY(Entry, Label)			\
    {								\
	fflush(NULL); printf("\n");				\
	printf("    Number Entered: %.f", (double)Entry);	\
	printf(" (%s)\n", Label);				\
    }
#define	SHOW_INT_VALUE_USED(Entered, Used) 			\
	printf("    Test Value Used: %.f%s\n", (double)Used,	\
	((double)Entered == (double)Used) ? "" : " (Clamped)")

/* ==================================================================== */
/* SetSerialCorrelationControls - Puts Control Parameters in Structure	*/
/* ==================================================================== */
void
SetSerialCorrelationControls(SERCOR_DATA_STRU *SerCorData)
{
    int     NewlineCh;			/* Carriage Control Char.	*/
    UINT    UserUintEntry;
    char    Prompt[128];

    NewlineCh = _isatty(_fileno(stdin)) ? '\r' : '\n';

    /* ------------------------------------------------------ */
    /* Request Number of Coefficients Per Chi-Square Variable */
    /* ------------------------------------------------------ */
    GetUint(NEED_USER_ENTRY(COEFS_PER_CHI_SQ, MIN_CHI_SQ, MAX_CHI_SQ),
	&UserUintEntry);

    REPORT_USER_INT_ENTRY(UserUintEntry, COEFS_PER_CHI_SQ);

    CLAMP(SerCorData->NumCoefs, UserUintEntry,
	MIN_CHI_SQ, MAX_CHI_SQ);

    SHOW_INT_VALUE_USED(UserUintEntry, SerCorData->NumCoefs);

    /* --------------------------------------------------- */
    /* Request Number of Variates to be Generated Per Pass */
    /* --------------------------------------------------- */
    fflush(NULL); fprintf(stderr, "%c", NewlineCh);

    sprintf(Prompt, "Enter %s [%u-%u]: ", VARIATES_PER_CHI_SQ,
	SerCorData->NumCoefs + 3, MAX_VARIATES);

    GetUint(Prompt, &UserUintEntry);

    REPORT_USER_INT_ENTRY(UserUintEntry, VARIATES_PER_CHI_SQ);

    CLAMP(SerCorData->NumVarPerPass, UserUintEntry,
	SerCorData->NumCoefs + 3, MAX_VARIATES);

    SHOW_INT_VALUE_USED(UserUintEntry, SerCorData->NumVarPerPass);
}
